import torch
from torchvision.models import mobilenet_v2
from torch import nn

def mobilenet(num_classes, in_channels=3):
    model = mobilenet_v2(pretrained=False)
    # Adjust the first convolution layer
    if in_channels != 3:
        first_conv_layer = model.features[0][0]
        model.features[0][0] = nn.Conv2d(in_channels, first_conv_layer.out_channels,
                                         kernel_size=first_conv_layer.kernel_size, 
                                         stride=first_conv_layer.stride, 
                                         padding=first_conv_layer.padding, 
                                         bias=False)

    # Adjust the classifier layer
    num_features = model.classifier[1].in_features
    model.classifier[1] = nn.Linear(num_features, num_classes)
    return model

# # Example usage for MedMNIST
# num_classes = 10  # Adjust based on specific MedMNIST dataset
# model_medmnist = mobilenet(num_classes, in_channels=1)  # For grayscale images
